<?= $this->extend('layouts/admin') ?>

<?= $this->section('content') ?>
<div class="d-flex justify-content-between align-items-center mb-4">
    <h2 class="mb-0">
        <i class="bi bi-plus-circle me-2"></i>Tambah Organisasi
    </h2>
    <a href="<?= base_url('admin/organizations') ?>" class="btn btn-secondary">
        <i class="bi bi-arrow-left me-1"></i>Kembali
    </a>
</div>

<?php if (session()->getFlashdata('errors')): ?>
    <div class="alert alert-danger alert-dismissible fade show" role="alert">
        <ul class="mb-0">
            <?php foreach (session()->getFlashdata('errors') as $error): ?>
                <li><?= $error ?></li>
            <?php endforeach; ?>
        </ul>
        <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
    </div>
<?php endif; ?>

<div class="admin-card">
    <form action="<?= base_url('admin/organizations/store') ?>" method="POST">
        <?= csrf_field() ?>
        
        <div class="row">
            <div class="col-md-6 mb-3">
                <label for="nama_organisasi" class="form-label">Nama Organisasi <span class="text-danger">*</span></label>
                <input type="text" class="form-control" id="nama_organisasi" name="nama_organisasi" 
                       value="<?= old('nama_organisasi') ?>" required>
            </div>
            <div class="col-md-6 mb-3">
                <label for="jabatan" class="form-label">Jabatan</label>
                <input type="text" class="form-control" id="jabatan" name="jabatan" 
                       value="<?= old('jabatan') ?>" placeholder="Contoh: Ketua, Anggota, dll">
            </div>
        </div>

        <div class="row">
            <div class="col-md-4 mb-3">
                <label for="tahun_mulai" class="form-label">Tahun Mulai</label>
                <input type="number" class="form-control" id="tahun_mulai" name="tahun_mulai" 
                       value="<?= old('tahun_mulai') ?>" min="1900" max="2100" placeholder="Contoh: 2020">
            </div>
            <div class="col-md-4 mb-3">
                <label for="tahun_selesai" class="form-label">Tahun Selesai</label>
                <input type="number" class="form-control" id="tahun_selesai" name="tahun_selesai" 
                       value="<?= old('tahun_selesai') ?>" min="1900" max="2100" placeholder="Contoh: 2023">
            </div>
            <div class="col-md-4 mb-3">
                <label for="urutan" class="form-label">Urutan</label>
                <input type="number" class="form-control" id="urutan" name="urutan" 
                       value="<?= old('urutan', 0) ?>" min="0">
            </div>
        </div>

        <div class="mb-3">
            <label for="deskripsi" class="form-label">
                <i class="bi bi-file-text me-1"></i>Deskripsi
            </label>
            
            <div class="position-relative">
                <textarea class="form-control" id="deskripsi" name="deskripsi" rows="5" 
                          placeholder="Tulis deskripsi organisasi..."><?= old('deskripsi') ?></textarea>
                

            </div>
        </div>

        <div class="d-flex gap-2">
            <button type="submit" class="btn btn-primary">
                <i class="bi bi-save me-1"></i>Simpan
            </button>
            <a href="<?= base_url('admin/organizations') ?>" class="btn btn-secondary">
                <i class="bi bi-x me-1"></i>Batal
            </a>
        </div>
    </form>
</div>
<?= $this->endSection() ?>




